/******************************************************************************************************
 **                                                                                                  **
 **                     Ex Read Temp&Humidity SHT31-RTC Display to I2C LCD                           **
 **                                                                                                  ** 
 ******************************************************************************************************
 **                                                                                                  **
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.8.5                                                              **
 **                                                                                                  **                   
 **   Port Interface    :    Mega1280 Pin                           Device Interface                 **
 **                         --------------                     ---------------------                 **
 **                                                                                                  **
 **  I2C LCD            :   Pin D21(SCL)                                  SCL_LCD                    **                                                                                                  
 **                         Pin D20(SDA)                                  SDA-LCD                    **
 **                         I2C LCD Address = 0x3F(PCF8574A)                                         **
 **                                                                                                  **                         
 **                                                                                                  **
 **   I2C SHT31         :   Pin D21(SCL)                                  SCL-SHT31                  **                                                                                                             
 **                         Pin D20(SDA)                                  SDA-SHT31                  **   
 **                         I2C SHT31 Address = 0x44 (When ADDR=0)                                   **
 **                                                                                                  **
 **                                                                                                  **
 **                                                                                                  **
 ******************************************************************************************************/


#include <Wire.h>                //for LCD
#include <LiquidCrystal_I2C.h>   // For LCD

#include <Adafruit_SHT31.h>      //For SHT31


LiquidCrystal_I2C lcd(0x3F,16,2);  // set the LCD address to 0x3F for a 16 chars and 2 line display


//------Create an instance of the SHT31 sensor-----

Adafruit_SHT31  SHT31  ;

#define Addr_SHT31   0x44    
 
//#########################################################################
//##                          SETUP LOOP                                 ##
//#########################################################################

void setup() 
{ 
  
  Wire.begin()                     ;  // Start the I2C interface RTC
 

  lcd.init();                      // initialize the lcd 
  lcd.init();
  lcd.backlight();
  
  SHT31.begin(Addr_SHT31)   ;       
  delay(50)                 ; 
}



//######################################################################
//##                              MAIN LOOP                           ##
//######################################################################

void loop() 
{

 float tempC    = 0 ;
 float humidity = 0 ;


 //---------Read values Temp&Humidity  from the sensor -----------
 
  tempC = SHT31.readTemperature();
  humidity = SHT31.readHumidity();

while(1)
{

  //--------------  Check if any reads failed or data not number and exit early (to try again). -------------
  
  if(isnan(tempC) || isnan(humidity))      // Check Value Hm & Tm if "not a number" returns 1
   {
     lcd.setCursor(3,0)               ;    //Set the cursor to column[3],Line[0] 
     lcd.print("Read Fail")           ;
     return ;
   }

  //---------Print Value Temp to LCD ---------
 
   lcd.setCursor(0,0)                ;    //Set the cursor to column[0],Line[0] 
   lcd.print("T=")                   ;
   lcd.setCursor(6,0)                ;    //Set the cursor to column[6],Line[0] 
   lcd.write(0xDF)                   ;    //Print degree
   lcd.print('C')                    ;
  
   lcd.setCursor(2,0)                ;    //Set the cursor to column[2],Line[0] 
   lcd.print(tempC,1)                ;    //Print degree  point 1 Position

  //--------- Print Value Humidity to LCD -----------
  
   lcd.setCursor(0,1)                ;    //Set the cursor to column[0],Line[1] 
   lcd.print(",H=")                  ; 
   lcd.setCursor(7,1)                ;    //Set the cursor to column[7],Line[0=1] 
   lcd.print('%')                    ;
 
   lcd.setCursor(3,1)                ;    //Set the cursor to column[3],Line[1] 
   lcd.print(humidity,1)             ;    //Print Humidity Point 1 Position

 }
     
} //end loop




 

